package ru.yandex.webmaster3.viewer.http.searchurl.memorandum;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.storage.searchurl.samples.data.MemorandumSample;

import java.util.List;

/**
 * @author avhaliullin
 */
public class MemorandumBannedSamplesResponse implements ActionResponse.NormalResponse {
    private final long totalSamples;
    private final List<MemorandumSample> samples;

    public MemorandumBannedSamplesResponse(long totalSamples, List<MemorandumSample> samples) {
        this.totalSamples = totalSamples;
        this.samples = samples;
    }

    @Description("количество доступных примеров страниц")
    public long getTotalSamples() {
        return totalSamples;
    }

    @Description("список примеров страниц")
    public List<MemorandumSample> getSamples() {
        return samples;
    }
}
