package ru.yandex.webmaster3.viewer.http.searchurl.urls;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.links.DateHistory;
import ru.yandex.webmaster3.core.link.DatePoint;
import ru.yandex.webmaster3.viewer.http.searchurl.urls.data.SearchUrlIndicator;
import ru.yandex.webmaster3.viewer.http.searchurl.urls.data.SearchUrlIndicatorType;

import java.util.List;

/**
 * @author avhaliullin
 */
public class SearchUrlHistoryResponse implements ActionResponse.NormalResponse, DateHistory<SearchUrlIndicatorType> {
    private final List<SearchUrlHistory> histories;

    public SearchUrlHistoryResponse(List<SearchUrlHistory> histories) {
        this.histories = histories;
    }

    @Override
    public List<SearchUrlHistory> getHistories() {
        return histories;
    }

    public static class SearchUrlHistory implements History<SearchUrlIndicatorType> {
        private final List<DatePoint> data;
        private final SearchUrlIndicator indicator;

        public SearchUrlHistory(List<DatePoint> data, Long nodeId) {
            this.data = data;
            this.indicator = new SearchUrlIndicator(nodeId);
        }

        @Override
        public SearchUrlIndicatorType getIndicatorName() {
            return indicator.getName();
        }

        @Override
        public SearchUrlIndicator getIndicator() {
            return indicator;
        }

        @Override
        public List<DatePoint> getData() {
            return data;
        }
    }
}
