package ru.yandex.webmaster3.viewer.http.serplinks;

import java.util.List;

import org.springframework.beans.factory.annotation.Required;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.storage.serplinks.SerpLinkInfo;
import ru.yandex.webmaster3.storage.serplinks.W3SerpLinksService;
import ru.yandex.webmaster3.storage.serplinks.data.SerpLinksSectionId;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author avhaliullin
 */
@ReadAction
@Description(value="Информация о быстрых ссылках для хоста")
@Category("serplinks")
public class GetSerpLinksAction extends AbstractUserVerifiedHostAction<GetSerpLinksRequest, GetSerpLinksResponse> {
    private W3SerpLinksService w3SerpLinksService;

    @Override
    public GetSerpLinksResponse process(GetSerpLinksRequest request) {
        List<String> sections = w3SerpLinksService.getSections(request.getHostId());
        String section = request.getSection();
        if (sections.isEmpty()) {
            return new GetSerpLinksResponse.NoInfoForHostResponse(getClass());
        }
        if (section == null) {
            section = sections.get(0);
        }
        SerpLinkInfo serpLinks = w3SerpLinksService
                .getSerpLinkInfoDiff(new SerpLinksSectionId(request.getHostId(), section));
        W3SerpLinksService.Sort sort =
                serpLinks.isAlphaSort() ? W3SerpLinksService.Sort.ALPHA : W3SerpLinksService.Sort.WEIGHT;
        return new GetSerpLinksResponse.NormalResponse(sections, serpLinks.getPages(), sort, section, serpLinks.isBlocked());
    }

    @Required
    public void setW3SerpLinksService(W3SerpLinksService w3SerpLinksService) {
        this.w3SerpLinksService = w3SerpLinksService;
    }

}
