package ru.yandex.webmaster3.viewer.http.serplinks;

import java.util.List;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.storage.serplinks.SerpLinkInfo;
import ru.yandex.webmaster3.storage.serplinks.W3SerpLinksService;

/**
 * @author avhaliullin
 */
public abstract class GetSerpLinksResponse implements ActionResponse {
    public static class NormalResponse extends GetSerpLinksResponse implements ActionResponse.NormalResponse {
        private final List<String> sections;
        private final List<SerpLinkInfo.SerpLinksPage> serpLinks;
        private final W3SerpLinksService.Sort sort;
        private final String section;
        private final boolean blocked;

        public NormalResponse(List<String> sections, List<SerpLinkInfo.SerpLinksPage> serpLinks,
                              W3SerpLinksService.Sort sort, String section, boolean blocked) {
            this.sections = sections;
            this.serpLinks = serpLinks;
            this.sort = sort;
            this.section = section;
            this.blocked = blocked;
        }

        public List<String> getSections() {
            return sections;
        }

        public List<SerpLinkInfo.SerpLinksPage> getSerpLinks() {
            return serpLinks;
        }

        public W3SerpLinksService.Sort getSort() {
            return sort;
        }

        public String getSection() {
            return section;
        }

        @Description("секция заблокирована")
        public boolean isBlocked() {
            return blocked;
        }
    }

    public static enum GetSerpLinksErrorType {
        GET_SERP_LINKS__NO_INFO_FOR_HOST,
    }
    @Description("Для хоста нет быстрых ссылок")
    public static class NoInfoForHostResponse extends GetSerpLinksResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public NoInfoForHostResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Enum<?> getCode() {
            return GetSerpLinksErrorType.GET_SERP_LINKS__NO_INFO_FOR_HOST;
        }

        @Override
        public Class<?> getClazz() {
            return clazz;
        }

        @Override
        public String getMessage() {
            return "No serp links secitons for host";
        }
    }
}
