package ru.yandex.webmaster3.viewer.http.serplinks;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.storage.serplinks.data.SerpLinkUpdateInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.storage.serplinks.W3SerpLinksService;
import ru.yandex.webmaster3.storage.serplinks.data.SerpLinksSectionId;

import java.util.Arrays;
import java.util.List;

/**
 * @author avhaliullin
 */
@WriteAction
@Description(value = "Сохранить настройки быстрых ссылок для хоста")
@Category("serplinks")
public class UpdateSerpLinksAction extends AbstractUserVerifiedHostAction<UpdateSerpLinksRequest, UpdateSerpLinksResponse> {
    private static final Logger log = LoggerFactory.getLogger(UpdateSerpLinksAction.class);

    private W3SerpLinksService w3SerpLinksService;

    @Override
    public UpdateSerpLinksResponse process(UpdateSerpLinksRequest request) {
        assertPagesArrayIsValid(request.getPages());
        SerpLinksSectionId sectionId = new SerpLinksSectionId(request.getHostId(), request.getSection());
        List<SerpLinkUpdateInfo> links = null;
        if (request.getPages() != null && request.getPages().length > 0) {
            links = Arrays.asList(request.getPages());
        }
        W3SerpLinksService.UpdateResult result = w3SerpLinksService.updateInfo(sectionId, request.getSort(), links,
                request.isBlocked());
        switch (result) {
            case OK:
                return new UpdateSerpLinksResponse.NormalResponse();
            case EXPIRED:
                return new UpdateSerpLinksResponse.ExpiredInfoResponse(getClass());
            case SECTION_DOESNT_EXIST:
                return new UpdateSerpLinksResponse.SectionDoesntExistResponse(getClass());
            default:
                throw new RuntimeException("Unknown serp links update result: " + result);
        }
    }

    private void assertPagesArrayIsValid(SerpLinkUpdateInfo[] pages) {
        if (pages != null && pages.length > 0) {
            for (int i = 0; i < pages.length; i++) {
                SerpLinkUpdateInfo page = pages[i];
                String paramBase = "pages[" + i + "].";
                if (page.getId() == null) {
                    String parameterName = paramBase + "id";
                    throw new WebmasterException("Required parameter missing: name=" + parameterName + " class=String",
                            new WebmasterErrorResponse.IllegalParameterValueResponse(this.getClass(), parameterName, null));
                }
            }
        }
    }

    @Required
    public void setW3SerpLinksService(W3SerpLinksService w3SerpLinksService) {
        this.w3SerpLinksService = w3SerpLinksService;
    }
}
