package ru.yandex.webmaster3.viewer.http.serplinks;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestPostProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.serplinks.W3SerpLinksService;
import ru.yandex.webmaster3.storage.serplinks.data.SerpLinkUpdateInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author avhaliullin
 */
public class UpdateSerpLinksRequest extends AbstractUserVerifiedHostRequest {
    private W3SerpLinksService.Sort sort = W3SerpLinksService.Sort.WEIGHT;
    private String section;
    private SerpLinkUpdateInfo[] pages;
    private boolean blocked;

    public W3SerpLinksService.Sort getSort() {
        return sort;
    }

    @Description(value = "Cпособ сортировки ссылок")
    @RequestQueryProperty(required = true)
    public void setSort(W3SerpLinksService.Sort sort) {
        this.sort = sort;
    }

    public String getSection() {
        return section;
    }

    @Description(value = "Раздел сайта")
    @RequestQueryProperty(required = true)
    public void setSection(String section) {
        this.section = section;
    }

    public SerpLinkUpdateInfo[] getPages() {
        return pages;
    }

    @Description(value = "Изменения в ссылках")
    @RequestPostProperty
    public void setPages(SerpLinkUpdateInfo[] pages) {
        this.pages = pages;
    }

    @Description(value = "Заблокировать/разблокировать секцию")
    @RequestQueryProperty
    public void setBlocked(boolean blocked) {
        this.blocked = blocked;
    }

    public boolean isBlocked() {
        return blocked;
    }
}
