package ru.yandex.webmaster3.viewer.http.serplinks;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class UpdateSerpLinksResponse implements ActionResponse {
    public static class NormalResponse extends UpdateSerpLinksResponse implements ActionResponse.NormalResponse {
    }

    public static enum UpdateSerpLinksErrorType {
        UPDATE_SERP_LINKS__EXPIRED_INFO,
        UPDATE_SERP_LINKS__SECTION_DOESNT_EXIST,
    }

    @Description("Невозможно применить изменения, так как информация о быстрых ссылках устарела")
    public static class ExpiredInfoResponse extends UpdateSerpLinksResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public ExpiredInfoResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Enum<?> getCode() {
            return UpdateSerpLinksErrorType.UPDATE_SERP_LINKS__EXPIRED_INFO;
        }

        @Override
        public Class<?> getClazz() {
            return clazz;
        }

        @Override
        public String getMessage() {
            return "Serp links information is out of date";
        }
    }

    @Description("Указанная секция не существует")
    public static class SectionDoesntExistResponse extends UpdateSerpLinksResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;

        public SectionDoesntExistResponse(Class<?> clazz) {
            this.clazz = clazz;
        }

        @Override
        public Enum<?> getCode() {
            return UpdateSerpLinksErrorType.UPDATE_SERP_LINKS__SECTION_DOESNT_EXIST;
        }

        @Override
        public Class<?> getClazz() {
            return clazz;
        }

        @Override
        public String getMessage() {
            return "Serp links section doesn't exist";
        }
    }
}
