package ru.yandex.webmaster3.viewer.http.sitemap;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.util.sitemap.SitemapRecrawlQuotaUtil;
import ru.yandex.webmaster3.storage.sitemap.SitemapRecrawlRequestService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.sitemap.data.HostRecrawlSitemapsLimitInfo;

/**
 * Created by ifilippov5 on 13.08.17.
 */
@ReadAction
@Description(value = "Получение лимитов на переобход сайтмапов для хоста")
@Category("sitemap")
public class GetHostRecrawlSitemapsLimitsAction extends AbstractUserVerifiedHostAction<GetHostRecrawlSitemapsLimitsRequest, GetHostRecrawlSitemapsLimitsResponse> {

    private SitemapRecrawlRequestService sitemapRecrawlRequestService;

    @Override
    public GetHostRecrawlSitemapsLimitsResponse process(GetHostRecrawlSitemapsLimitsRequest request) {
        SitemapRecrawlQuotaUtil.QuotaUsage quotaUsage = sitemapRecrawlRequestService.getHostRecrawlQuotaInfo(request.getHostId());

        return new GetHostRecrawlSitemapsLimitsResponse.NormalResponse(new HostRecrawlSitemapsLimitInfo(
                    quotaUsage.getMonthlyQuota(),
                    quotaUsage.getQuotaUsed(),
                    quotaUsage.getNearestAllowedDay()));
    }

    @Required
    public void setSitemapRecrawlRequestService(SitemapRecrawlRequestService sitemapRecrawlRequestService) {
        this.sitemapRecrawlRequestService = sitemapRecrawlRequestService;
    }
}
