package ru.yandex.webmaster3.viewer.http.sitemap;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitemap.SitemapInfo;
import ru.yandex.webmaster3.storage.sitemap.dao.SitemapsCHDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * @author aherman
 */
@ReadAction
@Category("sitemap")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class GetSitemapInfoAction extends AbstractUserVerifiedHostAction<GetSitemapInfoRequest, GetSitemapInfoResponse> {

    private final SitemapsCHDao sitemapsCHDao;

    @Override
    public GetSitemapInfoResponse process(GetSitemapInfoRequest request) {
        return new GetSitemapInfoResponse.NormalResponse(
                sitemapsCHDao.getSitemap(request.getHostId(), request.getParentSitemapId(), request.getSitemapId())
                        .map(SitemapInfo::toHostSitemapInfo).orElse(null)
        );
    }
}
