package ru.yandex.webmaster3.viewer.http.sitemap;

import java.util.List;

import org.joda.time.DateTime;

import ru.yandex.webmaster3.core.data.HttpCodeInfo;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.sitemap.HostSitemapInfo;
import ru.yandex.webmaster3.core.sitemap.SitemapType;

/**
 * @author aherman
 */
public abstract class GetSitemapInfoResponse implements ActionResponse {
    public static class NormalResponse extends GetSitemapInfoResponse implements ActionResponse.NormalResponse {
        private final DateTime lastAccessDate;
        private final HttpCodeInfo httpCodeInfo;
        private final List<HostSitemapInfo.SitemapError> errors;
        private final List<HostSitemapInfo.SitemapError> warnings;

        private final Long shownErrorsCount;
        private final Long shownWarningsCount;
        private final Long urlCount;
        private final String sitemapFileName;
        private final SitemapType sitemapType;

        public NormalResponse(HostSitemapInfo sitemapInfo) {
            if (sitemapInfo != null) {
                this.lastAccessDate = sitemapInfo.getLastAccessDate();
                this.httpCodeInfo = sitemapInfo.getHttpCodeInfo();
                this.errors = sitemapInfo.getErrors();
                this.warnings = sitemapInfo.getWarnings();
                this.shownErrorsCount = sitemapInfo.getShownErrorsCount();
                this.shownWarningsCount = sitemapInfo.getShownWarningsCount();
                this.urlCount = sitemapInfo.getUrlCount();
                this.sitemapFileName = sitemapInfo.getSitemapFileName();
                this.sitemapType = sitemapInfo.getSitemapType();
            } else {
                this.lastAccessDate = null;
                this.httpCodeInfo = null;
                this.errors = null;
                this.warnings = null;
                this.shownErrorsCount = null;
                this.shownWarningsCount = null;
                this.urlCount = null;
                this.sitemapFileName = null;
                this.sitemapType = null;
            }
        }

        public DateTime getLastAccessDate() {
            return lastAccessDate;
        }

        public HttpCodeInfo getHttpCodeInfo() {
            return httpCodeInfo;
        }

        public List<HostSitemapInfo.SitemapError> getErrors() {
            return errors;
        }

        public List<HostSitemapInfo.SitemapError> getWarnings() {
            return warnings;
        }

        public Long getShownErrorsCount() {
            return shownErrorsCount;
        }

        public Long getShownWarningsCount() {
            return shownWarningsCount;
        }

        public Long getUrlCount() {
            return urlCount;
        }

        public String getSitemapFileName() {
            return sitemapFileName;
        }

        public SitemapType getSitemapType() {
            return sitemapType;
        }
    }

    public static enum GetSitemapInfoErrorType {
        GET_SITEMAP_INFO__SITEMAP_NOT_FOUND,
    }

    static abstract class BaseErrorResponse extends GetSitemapInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class SitemapNotFoundResponse extends BaseErrorResponse {
        public SitemapNotFoundResponse(Class<?> clazz) {
            super(clazz);
        }
        @Override
        public Enum<?> getCode() {
            return GetSitemapInfoErrorType.GET_SITEMAP_INFO__SITEMAP_NOT_FOUND;
        }
        @Override
        public String getMessage() {
            return "Sitemap not found";
        }
    }
}
