package ru.yandex.webmaster3.viewer.http.sitemap;

import java.util.UUID;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * @author aherman
 */
public class ListSitemapChildrenRequest extends AbstractUserVerifiedHostRequest {
    private UUID parentSitemapId;
    private UUID fromSitemapId;
    private int pageSize;

    public UUID getParentSitemapId() {
        return parentSitemapId;
    }

    @Description(value="id сайтмапа для получения дочерних сайтмапов в индексном сайтмапе")
    @RequestQueryProperty(required = true)
    public void setParentSitemapId(UUID parentSitemapId) {
        this.parentSitemapId = parentSitemapId;
    }

    public UUID getFromSitemapId() {
        return fromSitemapId;
    }

    @Description(value="Идентификатор последнего сайтмапа на предыдущей странице для пагинации")
    @RequestQueryProperty
    public void setFromSitemapId(UUID fromSitemapId) {
        this.fromSitemapId = fromSitemapId;
    }

    @Description(value="Размер страницы для пагинации")
    @RequestQueryProperty
    public void setPSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public int getPageSize() {
        return pageSize;
    }

}
