package ru.yandex.webmaster3.viewer.http.sitemap;

import java.util.List;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.sitemap.data.RecrawlableHostSitemap;

/**
 * @author aherman
 */
public abstract class ListSitemapChildrenResponse implements ActionResponse {
    public static class NormalResponse extends ListSitemapChildrenResponse implements ActionResponse.NormalResponse {
        private final List<RecrawlableHostSitemap> sitemaps;

        public NormalResponse(List<RecrawlableHostSitemap> sitemaps) {
            this.sitemaps = sitemaps;
        }

        public List<RecrawlableHostSitemap> getSitemaps() {
            return sitemaps;
        }
    }
}
