package ru.yandex.webmaster3.viewer.http.sitemap;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

import java.util.UUID;

/**
 * Created by leonidrom on 22/05/2017.
 */
public class RecrawlSitemapActionRequest extends AbstractUserVerifiedHostRequest {
    private UUID sitemapId;
    private UUID parentSitemapId;

    @Description(value="Sitemap id для переобхода")
    @RequestQueryProperty(required = true)
    public void setSitemapId(UUID sitemapId) {
        this.sitemapId = sitemapId;
    }

    public UUID getSitemapId() {
        return sitemapId;
    }

    @Description(value="Parent sitemap id для переобхода")
    @RequestQueryProperty()
    public void setParentSitemapId(UUID parentSitemapId) {
        this.parentSitemapId = parentSitemapId;
    }

    public UUID getParentSitemapId() {
        return parentSitemapId;
    }
}
