package ru.yandex.webmaster3.viewer.http.sitemap;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.util.sitemap.SitemapRecrawlQuotaUtil;
import ru.yandex.webmaster3.viewer.http.sitemap.data.HostRecrawlSitemapsLimitInfo;
import ru.yandex.webmaster3.viewer.http.sitemap.data.SitemapRecrawlInfo;

/**
 * Created by leonidrom on 22/05/2017.
 */
public abstract class RecrawlSitemapActionResponse implements ActionResponse {
    public static class NormalResponse extends RecrawlSitemapActionResponse implements ActionResponse.NormalResponse {
        private final SitemapRecrawlInfo sitemapRecrawlInfo;
        private final HostRecrawlSitemapsLimitInfo hostSitemapsRecrawlLimitInfo;

        public NormalResponse(SitemapRecrawlInfo sitemapRecrawlInfo, HostRecrawlSitemapsLimitInfo hostSitemapsRecrawlLimitInfo) {
            this.sitemapRecrawlInfo = sitemapRecrawlInfo;
            this.hostSitemapsRecrawlLimitInfo = hostSitemapsRecrawlLimitInfo;
        }

        @Description("Все что имеет отношение к переобходу")
        public SitemapRecrawlInfo getSitemapRecrawlInfo() {
            return sitemapRecrawlInfo;
        }

        @Description("Информация о лимитах на переобход для хоста")
        public HostRecrawlSitemapsLimitInfo getHostSitemapsRecrawlLimitInfo() {
            return hostSitemapsRecrawlLimitInfo;
        }
    }

    public enum RecrawlSitemapErrorType {
        RECRAWL_SITEMAP__RECRAWL_IN_PROCESS,
        RECRAWL_SITEMAP__HOST_RECRAWLS_QUOTA_EXCEEDED,
        RECRAWL_SITEMAP__SITEMAP_NOT_FOUND,
    }

    static abstract class BaseErrorResponse extends RecrawlSitemapActionResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static class RecrawlInProcessResponse extends RecrawlSitemapActionResponse.BaseErrorResponse {
        private final SitemapRecrawlInfo sitemapRecrawlInfo;
        public RecrawlInProcessResponse(Class<?> clazz, SitemapRecrawlInfo sitemapRecrawlInfo) {
            super(clazz);
            this.sitemapRecrawlInfo = sitemapRecrawlInfo;
        }
        @Override
        public Enum<?> getCode() {
            return RecrawlSitemapErrorType.RECRAWL_SITEMAP__RECRAWL_IN_PROCESS;
        }
        @Override
        public String getMessage() {
            return "Recrawl in process";
        }

        public SitemapRecrawlInfo getSitemapRecrawlInfo() {
            return sitemapRecrawlInfo;
        }
    }

    public static class HostRecrawlsQuotaExceededResponse extends RecrawlSitemapActionResponse.BaseErrorResponse {
        private final SitemapRecrawlQuotaUtil.QuotaUsage quotaInfo;
        public HostRecrawlsQuotaExceededResponse(Class<?> clazz, SitemapRecrawlQuotaUtil.QuotaUsage quotaInfo) {
            super(clazz);
            this.quotaInfo = quotaInfo;
        }
        @Override
        public Enum<?> getCode() {
            return RecrawlSitemapErrorType.RECRAWL_SITEMAP__HOST_RECRAWLS_QUOTA_EXCEEDED;
        }
        @Override
        public String getMessage() {
            return "Host recrawls per month quota exceeded";
        }

        public SitemapRecrawlQuotaUtil.QuotaUsage getQuotaInfo() {
            return quotaInfo;
        }
    }

    public static class SitemapNotFoundResponse extends RecrawlSitemapActionResponse.BaseErrorResponse {
        public SitemapNotFoundResponse(Class<?> clazz) {
            super(clazz);
        }
        @Override
        public Enum<?> getCode() {
            return RecrawlSitemapErrorType.RECRAWL_SITEMAP__SITEMAP_NOT_FOUND;
        }
        @Override
        public String getMessage() {
            return "Sitemap not found";
        }
    }
}
