package ru.yandex.webmaster3.viewer.http.sitemap.analyze.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.FileParameter;
import ru.yandex.webmaster3.core.http.RequestFileProperty;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

/**
 * User: azakharov
 * Date: 11.06.14
 * Time: 15:06
 */
public class AnalyzeSitemapRequest extends AbstractFrontendRequest {
    private long userId;

    private String sitemapText;
    private String sitemapUrl;
    private FileParameter sitemapFile;

    @Description(value="Идентификатор пользователя")
    @RequestQueryProperty
    public void setUserId(long userId) {
        this.userId = userId;
    }

    public long getUserId() {
        return userId;
    }

    @Description(value="Текст файла sitemap")
    @RequestQueryProperty
    public void setSitemapText(String sitemapText) {
        this.sitemapText = sitemapText;
    }

    public String getSitemapText() {
        return sitemapText;
    }

    @Description(value="URL файла sitemap")
    @RequestQueryProperty
    public void setSitemapUrl(String sitemapUrl) {
        this.sitemapUrl = sitemapUrl;
    }

    public String getSitemapUrl() {
        return sitemapUrl;
    }

    public FileParameter getSitemapFile() {
        return sitemapFile;
    }

    @Description(value="Имя загружаемого файла")
    @RequestFileProperty
    public void setSitemapFile(FileParameter sitemapFile) {
        this.sitemapFile = sitemapFile;
    }
}
