package ru.yandex.webmaster3.viewer.http.sitemap.analyze.model;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;

import java.util.UUID;

/**
 * @author: ishalaru
 * DATE: 14.05.2019
 */
public abstract class StartSitememapAnalyzeResponse implements ActionResponse {
    public static class NormalResponse extends StartSitememapAnalyzeResponse implements ActionResponse.NormalResponse {
        private final UUID requestId;

        public NormalResponse(UUID requestId) {
            this.requestId = requestId;
        }

        @Description("id созданной заявки")
        public UUID getRequestId() {
            return requestId;
        }
    }

    public static abstract class AbstractErrorResponse extends StartSitememapAnalyzeResponse implements ActionResponse.ErrorResponse {
        private final StartSitemapAnalyzeErrorTypes errorType;

        public AbstractErrorResponse(StartSitemapAnalyzeErrorTypes errorType) {
            this.errorType = errorType;
        }

        @Override
        public Enum<?> getCode() {
            return errorType;
        }
    }

    public static class UniversalResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse{

        public UniversalResponse(StartSitemapAnalyzeErrorTypes errorType) {
            super(errorType);
        }
    }

    @Description("Передан невалидный текст")
    public static class InvalidInputTextResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public InvalidInputTextResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_INVALID_INPUT_TEXT);}
    }

    @Description("Входной текст слишком большой")
    public static class InputTextIsTooLargeResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public InputTextIsTooLargeResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_INPUT_TEXT_IS_TOO_LARGE);}
    }

    @Description("Пердан невалидный URL")
    public static class InvalidURLResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public InvalidURLResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_INVALID_URL);}
    }

    @Description("Переданый URL являеться домашней страницой")
    public static class UrlIsHomapageResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public UrlIsHomapageResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_URL_IS_HOMEPAGE);}
    }

    @Description("Переданный путь некорректен")
    public static class InvalidFilePathResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public InvalidFilePathResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_INVALID_FILE_PATH);}
    }

    @Description("Отсуствуют данные для обработки")
    public static class InvalidInputDataResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public InvalidInputDataResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_INVALID_INPUT_DATA);}
    }

    @Description("Превышен дневной лимит запросов для не верифицированных хостов")
    public static class RequestsLimitExceededResponse extends StartSitememapAnalyzeResponse.AbstractErrorResponse {
        public RequestsLimitExceededResponse() { super(StartSitemapAnalyzeErrorTypes.START_SITEMAP_ANALYZE_REQUESTS_LIMIT_EXCEEDED);}
    }
}
