package ru.yandex.webmaster3.viewer.http.sitemap.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

/**
 * Created by ifilippov5 on 31.08.17.
 */
public class HostRecrawlSitemapsLimitInfo {
    private final int monthlyLimitRequests;
    private final int requestsCount;
    private final DateTime nearestAllowedDay;

    public HostRecrawlSitemapsLimitInfo(int monthlyLimitRequests, int requestsCount, DateTime nearestAllowedDay) {
        this.monthlyLimitRequests = monthlyLimitRequests;
        this.requestsCount = requestsCount;
        this.nearestAllowedDay = nearestAllowedDay;
    }

    @Description(value="Месячный лимит запросов на переобход для хоста")
    public int getMonthlyLimitRequests() {
        return monthlyLimitRequests;
    }

    @Description(value="Количество сделанных запросов на переобход для хоста за последний месяц")
    public int getRequestsCount() {
        return requestsCount;
    }

    @Description(value="Ближайший дата, когда можно будет сделать очередной запрос на переобход. С точностью до дня.")
    public DateTime getNearestAllowedDay() {
        return nearestAllowedDay;
    }
}
