package ru.yandex.webmaster3.viewer.http.sitemap.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.sitemap.HostSitemap;

/**
 * Created by leonidrom on 23/05/2017.
 */
public class SitemapRecrawlInfo {
    private final boolean isAllowed;
    private final boolean isPending;
    private final DateTime lastRequestTime;

    private SitemapRecrawlInfo(boolean isAllowed, boolean isPending, DateTime lastRequestTime) {
        this.isAllowed = isAllowed;
        this.isPending = isPending;
        this.lastRequestTime = lastRequestTime;
    }

    @Description("Может ли пользователь запросить переобход")
    public boolean isAllowed() {
        return isAllowed;
    }

    @Description("Есть ли заявка на переобход в процессе выполнения")
    public boolean isPending() {
        return isPending;
    }

    @Description("Дата создания последней заявки на переобход")
    public DateTime getLastRequestTime() {
        return lastRequestTime;
    }

    public static SitemapRecrawlInfo from(DateTime lastAccessDate, DateTime lastRequestDate, boolean isAllowedForHost) {
        boolean isPending = (lastRequestDate != null);
        boolean isAllowed = isAllowedForHost;
        if (lastRequestDate != null) {
            if (lastAccessDate != null) {
                isPending = !lastAccessDate.isAfter(lastRequestDate);
            }
        }
        isAllowed &= (!isPending);

        return new SitemapRecrawlInfo(isAllowed, isPending, lastRequestDate);
    }

    public static SitemapRecrawlInfo newestRecrawl(DateTime requestTime) {
        return new SitemapRecrawlInfo(false, true, requestTime);
    }
}
