package ru.yandex.webmaster3.viewer.http.sitetree;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeNode;

/**
 * User: azakharov
 * Date: 27.08.14
 * Time: 17:40
 */
public abstract class AddSiteTreeNodeResponse implements ActionResponse {
    public static class NormalResponse extends AddSiteTreeNodeResponse implements ActionResponse.NormalResponse {
        final SiteTreeNode node;

        public NormalResponse(SiteTreeNode node) {
            this.node = node;
        }

        public SiteTreeNode getNode() {
            return node;
        }
    }

    static abstract class BaseErrorResponse extends AddSiteTreeNodeResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static enum AddSiteTreeNodeErrorType {
        ADD_SITE_TREE_NODE__INVALID_NODE_NAME,
        ADD_SITE_TREE_NODE__USER_NODE_COUNT_LIMIT_EXCEEDED,
        ADD_SITE_TREE_NODE__DUPLICATE_USER_NODE
    }

    public static class InvalidNodeNameResponse extends BaseErrorResponse {
        public InvalidNodeNameResponse(Class<?> clazz) {
            super(clazz);
        }
        @Override
        public Enum<?> getCode() {
            return AddSiteTreeNodeErrorType.ADD_SITE_TREE_NODE__INVALID_NODE_NAME;
        }
        @Override
        public String getMessage() {
            return "Provided node name is invalid";
        }
    }

    public static class UserNodeCountLimitExceeded extends BaseErrorResponse {
        public UserNodeCountLimitExceeded(Class<?> clazz) {
            super(clazz);
        }
        @Override
        public Enum<?> getCode() {
            return AddSiteTreeNodeErrorType.ADD_SITE_TREE_NODE__USER_NODE_COUNT_LIMIT_EXCEEDED;
        }
        @Override
        public String getMessage() {
            return "User site tree node count exceeded";
        }
    }

    public static class DuplicationUserNodeError extends BaseErrorResponse {
        public DuplicationUserNodeError(Class<?> clazz) {
            super(clazz);
        }

        @Override
        public Enum<?> getCode() {
            return AddSiteTreeNodeErrorType.ADD_SITE_TREE_NODE__DUPLICATE_USER_NODE;
        }
    }
}
