package ru.yandex.webmaster3.viewer.http.sitetree;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.RequestTimeout;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.user.dao.UserSiteTreeYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * User: azakharov
 * Date: 01.09.14
 * Time: 12:47
 */
@WriteAction
@Description(value = "Удаляет пользовательский раздел сайта.")
@RequestTimeout(4)
@Category("sitetree")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class DeleteSiteTreeNodeAction extends AbstractUserVerifiedHostAction<DeleteSiteTreeNodeRequest,
        DeleteSiteTreeNodeResponse> {
    private final UserSiteTreeYDao userSiteTreeYDao;

    @Override
    public DeleteSiteTreeNodeResponse process(DeleteSiteTreeNodeRequest request) {
        try {
            userSiteTreeYDao.deleteUserNode(request.getHostId(), request.getNodeId());
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Unable to save site tree to database",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }

        return new DeleteSiteTreeNodeResponse.OrdinaryResponse();
    }
}
