package ru.yandex.webmaster3.viewer.http.sitetree;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestTimeout;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeNode;
import ru.yandex.webmaster3.storage.sitestructure.SiteStructureService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * User: azakharov
 * Date: 09.10.14
 * Time: 12:50
 */

@ReadAction
@Description(value = "Выводит структуру сайта, предназначена для выбора раздела на графиках истории " +
        "и других местах, требующих выбора раздела")
@RequestTimeout(21)
@Category("sitetree")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class SelectTreeNodeAction extends AbstractUserVerifiedHostAction<SelectTreeNodeRequest, SelectTreeNodeResponse> {

    private final SiteStructureService siteStructureService;

    @Override
    public SelectTreeNodeResponse process(SelectTreeNodeRequest request) throws WebmasterException {
        Pair<List<SiteTreeNode>, List<SiteTreeNode>> pair = siteStructureService.getSiteTreeNodes(request.getHostId());
        return new SelectTreeNodeResponse.OrdinaryResponse(
                pair.getLeft().stream().map(SelectTreeNodeResponse.SiteTreeNode::fromTreeNode).collect(Collectors.toList()),
                pair.getRight().stream().map(SelectTreeNodeResponse.SiteTreeNode::fromTreeNode).collect(Collectors.toList())
        );
    }

}
