package ru.yandex.webmaster3.viewer.http.sitetree;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.sitestructure.TreeNode;

import java.util.List;

/**
 * User: azakharov
 * Date: 09.10.14
 * Time: 12:50
 */
public abstract class SelectTreeNodeResponse implements ActionResponse {
    public static class OrdinaryResponse extends SelectTreeNodeResponse implements ActionResponse.NormalResponse {
        private final List<SiteTreeNode> autoNodes;
        private final List<SiteTreeNode> userNodes;

        public OrdinaryResponse(List<SiteTreeNode> autoNodes, List<SiteTreeNode> userNodes) {
            this.autoNodes = autoNodes;
            this.userNodes = userNodes;
        }

        public List<SiteTreeNode> getAutoNodes() {
            return autoNodes;
        }

        public List<SiteTreeNode> getUserNodes() {
            return userNodes;
        }
    }

    public static class SiteTreeNode {
        private Long nodeId;
        private Long parentId;
        private String name;

        public SiteTreeNode(Long nodeId, Long parentId, String name) {
            this.nodeId = nodeId;
            this.parentId = parentId;
            this.name = name;
        }

        public Long getNodeId() {
            return nodeId;
        }

        public Long getParentId() {
            return parentId;
        }

        public String getName() {
            return name;
        }

        public static SiteTreeNode fromTreeNode(TreeNode n) {
            return new SiteTreeNode(n.getNodeId(), n.getParentId(), n.getRelativeName());
        }
    }
}
