package ru.yandex.webmaster3.viewer.http.sitetree;

import java.util.List;

import lombok.RequiredArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.oldwebmaster.compatibility.YandexSearchShard;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestTimeout;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeNode;
import ru.yandex.webmaster3.storage.sitestructure.SiteStructureService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * <p/>
 * Shows site structure.
 * <p/>
 * Contract with front end:
 * <ul>
 * <li>node name is response is provided without slash
 * </ul>
 * User: azakharov
 * Date: 22.08.14
 * Time: 16:31
 */
@ReadAction
@Description(value = "Структура сайта с точки зрения робота: " +
        "автоматически определённые и пользовательские разделы, а также статистика по ним.")
@RequestTimeout(27)
@Category("sitetree")
@Component("/sitetree/info")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class SiteTreeInfoAction extends AbstractUserVerifiedHostAction<SiteTreeInfoRequest, SiteTreeInfoResponse> {

    private final SiteStructureService siteStructureService;

    @Override
    public SiteTreeInfoResponse process(final SiteTreeInfoRequest request) throws WebmasterException {
        Pair<List<SiteTreeNode>, List<SiteTreeNode>> pair = siteStructureService.getSiteTreeNodes(request.getHostId(), true);
        return new SiteTreeInfoResponse.OrdinaryResponse(
                pair.getLeft(),
                pair.getRight(),
                YandexSearchShard.RU
        );
    }
}
