package ru.yandex.webmaster3.viewer.http.sitetree;

import java.util.List;

import ru.yandex.oldwebmaster.compatibility.YandexSearchShard;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.core.sitestructure.SiteTreeNode;

/**
 * User: azakharov
 * Date: 22.08.14
 * Time: 16:31
 */
public abstract class SiteTreeInfoResponse implements ActionResponse {
    public static class OrdinaryResponse extends SiteTreeInfoResponse implements ActionResponse.NormalResponse {
        private List<SiteTreeNode> nodes;
        private List<SiteTreeNode> userNodes;
        private YandexSearchShard searchShard;
        private long maxUserNodesCount = SiteTreeConstants.MAX_USER_NODE_COUNT;

        public OrdinaryResponse(List<SiteTreeNode> nodes, List<SiteTreeNode> userNodes, YandexSearchShard searchShard) {
            this.nodes = nodes;
            this.userNodes = userNodes;
            this.searchShard = searchShard;
        }

        public List<SiteTreeNode> getNodes() {
            return nodes;
        }

        public List<SiteTreeNode> getUserNodes() {
            return userNodes;
        }

        public YandexSearchShard getSearchShard() {
            return searchShard;
        }

        public long getMaxUserNodesCount() {
            return maxUserNodesCount;
        }
    }

    static abstract class BaseErrorResponse extends SiteTreeInfoResponse implements ActionResponse.ErrorResponse {
        private final Class<?> clazz;
        protected BaseErrorResponse(Class<?> clazz) {this.clazz = clazz;}
        @Override public Class<?> getClazz() {return clazz;}
    }

    public static enum SiteTreeInfoErrorType {
        SITE_TREE_ERROR_INFO__NO_DATA_FOR_HOST;
    }
}
