package ru.yandex.webmaster3.viewer.http.spam;

import java.util.HashMap;
import java.util.Map;

import com.datastax.driver.core.utils.UUIDs;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionRequest;
import ru.yandex.webmaster3.core.http.request.RequestContext;
import ru.yandex.webmaster3.core.http.request.RequestIdAware;
import ru.yandex.webmaster3.core.http.request.WebmasterHostIdAware;
import ru.yandex.webmaster3.core.http.request.WebmasterUserIdAware;
import ru.yandex.webmaster3.core.solomon.metric.SolomonCounter;
import ru.yandex.webmaster3.core.solomon.metric.SolomonKey;
import ru.yandex.webmaster3.core.solomon.metric.SolomonMetricConfiguration;
import ru.yandex.webmaster3.core.solomon.metric.SolomonMetricRegistry;
import ru.yandex.webmaster3.core.spam.CaptchaEvent;
import ru.yandex.webmaster3.core.spam.ShowCaptchaReason;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.spam.CaptchaEventsYDao;

/**
 * @author avhaliullin
 */
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Service
public class CaptchaMetricsService {
    private static final Logger log = LoggerFactory.getLogger(CaptchaMetricsService.class);

    private static final String SOLOMON_LABEL_EVENT = "captcha_event";
    private static final String SOLOMON_LABEL_REASON = "captcha_reason";

    @Setter
    private SolomonMetricConfiguration solomonMetricConfiguration;
    private final CaptchaEventsYDao captchaEventsYDao;
    private final SolomonMetricRegistry solomonMetricRegistry;

    private Map<ShowCaptchaReason, SolomonCounter> showMetrics;
    private SolomonCounter solveMetrics;

    public void init() {
        solveMetrics = solomonMetricRegistry.createCounter(solomonMetricConfiguration, SolomonKey.create(
                SOLOMON_LABEL_EVENT, CaptchaEvent.SOLVED.name()
        ));
        showMetrics = new HashMap<>();
        for (ShowCaptchaReason showReason : ShowCaptchaReason.values()) {
            SolomonKey baseKey = SolomonKey.create(SOLOMON_LABEL_EVENT, CaptchaEvent.REQUESTED.name());
            showMetrics.put(showReason, solomonMetricRegistry.createCounter(solomonMetricConfiguration, baseKey.withLabel(SOLOMON_LABEL_REASON, showReason.name())));
        }
    }

    public void captchaShown(RequestContext ctx, ActionRequest req, ShowCaptchaReason reason)  {
        log.info("Captcha shown for reason {}", reason);
        if (req instanceof WebmasterUserIdAware) {
            //todo: реализовать утилиту для работы с trait'ами запросов, избавиться от дублирования
            long userId = ((WebmasterUserIdAware) req).getUserId();
            String reqId = (req instanceof RequestIdAware) ? ((RequestIdAware) req).getBalancerRequestId().toString() : "none";
            WebmasterHostId hostId = (req instanceof WebmasterHostIdAware) ? ((WebmasterHostIdAware) req).getHostId() : null;
            captchaEventsYDao.addRecord(userId, reqId, UUIDs.timeBased(), ctx.getHttpRequest().getParameter("userIp"), hostId, CaptchaEvent.REQUESTED, reason, ctx.getActionName());
            showMetrics.get(reason).update();
        }
    }

    public void captchaSolved(RequestContext ctx, ActionRequest req)  {
        log.info("Captcha solved");
        if (req instanceof WebmasterUserIdAware) {
            long userId = ((WebmasterUserIdAware) req).getUserId();
            String reqId = (req instanceof RequestIdAware) ? ((RequestIdAware) req).getBalancerRequestId().toString() : "none";
            WebmasterHostId hostId = (req instanceof WebmasterHostIdAware) ? ((WebmasterHostIdAware) req).getHostId() : null;
            captchaEventsYDao.addRecord(userId, reqId, UUIDs.timeBased(), ctx.getHttpRequest().getParameter("userIp"), hostId, CaptchaEvent.SOLVED, null, ctx.getActionName());
            solveMetrics.update();
        }
    }
}
