package ru.yandex.webmaster3.viewer.http.sprav;

import java.util.List;

import lombok.RequiredArgsConstructor;
import lombok.Value;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.sprav.CompanyProfileInfo;
import ru.yandex.webmaster3.storage.sprav.CompanyProfileInfoYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.sprav.GetCompanyProfileInfoAction.Request;
import ru.yandex.webmaster3.viewer.http.sprav.GetCompanyProfileInfoAction.Response;

/**
 * Created by Oleg Bazdyrev on 20/11/2018.
 */
@ReadAction
@Category("sprav")
@Description("Получение информации об организации/организациях по хосту")
@RequiredArgsConstructor
public class GetCompanyProfileInfoAction extends AbstractUserVerifiedHostAction<Request, Response> {

    private final CompanyProfileInfoYDao companyProfileInfoYDao;

    @Override
    public Response process(Request request) {
        List<CompanyProfileInfo> profiles = companyProfileInfoYDao.list(request.getHostId());
        return new Response(profiles);
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

    }

    @Value
    public static class Response implements ActionResponse.NormalResponse {

        @Description("Информация о компаниях из Справочника")
        List<CompanyProfileInfo> profiles;
    }
}
