package ru.yandex.webmaster3.viewer.http.survey;

import java.util.Set;

import lombok.Getter;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Category;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.storage.user.ServiceSurvey;
import ru.yandex.webmaster3.storage.user.service.SurveyService;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;

@ReadAction
@Category("notifications")
@Description("Получить опрос по категории и языку")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/messages/serviceSurvey/list")
public class GetServiceSurveyAction extends BaseWebmaster3Action<GetServiceSurveyAction.GetServiceSurveyRequest,
        GetServiceSurveyAction.GetServiceSurveyResponse> {

    private final SurveyService surveyService;

    @Override
    public GetServiceSurveyResponse process(GetServiceSurveyRequest request) {
        Set<ServiceSurvey> serviceSurveys = surveyService.getServiceSurveys(request.getRouteName(), true,
                request.getHostId(), request.getUserId());
        return new GetServiceSurveyResponse(serviceSurveys);
    }

    @Getter
    public static class GetServiceSurveyRequest extends AbstractFrontendRequest {
        @Setter(onMethod_ = @RequestQueryProperty(required = true))
        private String routeName;
        @Setter(onMethod_ = @RequestQueryProperty(required = false))
        private WebmasterHostId hostId;
        @Setter(onMethod_ = @RequestQueryProperty(required = false))
        private long userId;
    }

    @Value
    public static class GetServiceSurveyResponse implements ActionResponse.NormalResponse {
        Set<ServiceSurvey> serviceSurvey;
    }
}
