package ru.yandex.webmaster3.viewer.http.threats;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;
import ru.yandex.webmaster3.viewer.http.threats.data.NonRecheckableThreat;
import ru.yandex.webmaster3.viewer.http.threats.data.RecheckableThreat;

import java.util.List;

/**
 * @author avhaliullin
 */
public class GetHostThreatsResponse implements ActionResponse.NormalResponse {
    private final List<RecheckableThreat> recheckableThreats;
    private final List<NonRecheckableThreat> notRecheckableThreats;

    public GetHostThreatsResponse(List<RecheckableThreat> recheckableThreats, List<NonRecheckableThreat> notRecheckableThreats) {
        this.recheckableThreats = recheckableThreats;
        this.notRecheckableThreats = notRecheckableThreats;
    }

    @Description("Угрозы, которые можно перепроверить прямо сейчас")
    public List<RecheckableThreat> getRecheckableThreats() {
        return recheckableThreats;
    }

    @Description("Угрозы, которые сейчас перепроверить нельзя")
    public List<NonRecheckableThreat> getNotRecheckableThreats() {
        return notRecheckableThreats;
    }
}
