package ru.yandex.webmaster3.viewer.http.threats;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ActionStatus;

/**
 * @author avhaliullin
 */
public abstract class RecheckHostThreatsResponse implements ActionResponse {
    public static class NormalResponse extends RecheckHostThreatsResponse implements ActionResponse.NormalResponse {
    }

    public enum Errors {
        NO_THREATS_TO_RECHECK,
    }

    @Description("На данный момент проблемы, которые можно было бы проверить, отсутствуют")
    public static class NoThreatsToRecheckResponse extends RecheckHostThreatsResponse implements ActionResponse.ErrorResponse {
        @Override
        public Errors getCode() {
            return Errors.NO_THREATS_TO_RECHECK;
        }
    }
}
