package ru.yandex.webmaster3.viewer.http.threats.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;
import java.util.Objects;

public abstract class AbstractThreat {
    private final WebmasterHostId hostId;
    private final String threat;
    private final String displayName;
    private final List<HostVerdictView> verdicts;
    private final List<UrlSampleView> threatUrlSamples;
    private final String sanction;

    public AbstractThreat(WebmasterHostId hostId, String threat, String displayName, String sanction, List<HostVerdictView> verdicts,
                          List<UrlSampleView> threatUrlSamples) {
        this.hostId = hostId;
        this.threat = threat;
        this.displayName = displayName;
        this.verdicts = verdicts;
        this.sanction = sanction;
        this.threatUrlSamples = threatUrlSamples;
    }

    /** Сырое имя угрозы из антивира-антиспама */
    @JsonIgnore
    public String getThreat() {
        return threat;
    }

    @JsonProperty("threat")
    @Description("Тип угрозы, список тут https://arc.yandex-team.ru/wsvn/arc/trunk/arcadia/yweb/safesearch/threats.json")
    public String getDisplayName() {
        return displayName;
    }

    @Description("Информация о вердиктах (если есть)")
    public List<HostVerdictView> getVerdicts() {
        return verdicts;
    }

    @Description("Применяемая санкция")
    public String getSanction() {
        return sanction;
    }

    @Description("Список урлов-примеров для угрозы")
    public List<UrlSampleView> getThreatUrlSamples() {
        return threatUrlSamples;
    }

    @Description("Хост для которого угроза")
    public WebmasterHostId getHostId(){
        return hostId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        AbstractThreat that = (AbstractThreat) o;

        return Objects.equals(displayName,that.displayName)
                && Objects.equals(threatUrlSamples, that.threatUrlSamples)
                && Objects.equals(hostId, that.hostId)
                && Objects.equals(sanction, that.sanction);
    }

    @Override
    public int hashCode() {
        return Objects.hash(displayName.hashCode(), hostId);
    }
}
