package ru.yandex.webmaster3.viewer.http.threats.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.List;

/**
 * @author avhaliullin
 */
public class HostVerdictView {
    private final String verdict;
    private final List<UrlSampleView> verdictUrlSamples;

    @JsonCreator
    public HostVerdictView(String verdict, List<UrlSampleView> verdictUrlSamples) {
        this.verdict = verdict;
        this.verdictUrlSamples = verdictUrlSamples;
    }

    @Description("Название вердикта")
    public String getVerdict() {
        return verdict;
    }

    @Description("Примеры зараженных урлов")
    public List<UrlSampleView> getVerdictUrlSamples() {
        return verdictUrlSamples;
    }

}
