package ru.yandex.webmaster3.viewer.http.threats.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;

public class NonRecheckableThreat extends AbstractThreat {
    private final DateTime canRecheckAfter;
    private final WebmasterHostId fromOtherHost; //TODO: remove when front move to hostId in AbstractThreat
    private final boolean recheckInProgress;

    public NonRecheckableThreat(String threat, String displayName, String sanction, List<HostVerdictView> verdicts,
                                List<UrlSampleView> threatUrlSamples, DateTime canRecheckAfter,
                                WebmasterHostId fromOtherHost, boolean recheckInProgress) {
        super(fromOtherHost, threat, displayName, sanction, verdicts, threatUrlSamples);
        this.canRecheckAfter = canRecheckAfter;
        this.fromOtherHost = fromOtherHost;
        this.recheckInProgress = recheckInProgress;
    }

    @Description("Когда можно будет перепроверить (может отсутствовать)")
    public DateTime getCanRecheckAfter() {
        return canRecheckAfter;
    }


    @Description("id другого хоста, если угроза распространилась с него (иначе - отсутствует)")
    public WebmasterHostId getFromOtherHost() {
        return fromOtherHost;
    }

    @Description("Проверка происходит сейчас. Если false - то это проблема просто не перепроверябельна")
    public boolean isRecheckInProgress() {
        return recheckInProgress;
    }
}
