package ru.yandex.webmaster3.viewer.http.threats.data;

import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;

import java.util.List;

public class RecheckableThreat extends AbstractThreat {
    private final DateTime nextRecheckAfter;
    private final DateTime lastClick;
    private final DateTime lastRecheck;

    public RecheckableThreat(
            String threat, String displayName, String sanction, List<HostVerdictView> verdicts,
             List<UrlSampleView> threatUrlSamples, DateTime nextRecheckAfter,
             WebmasterHostId hostId, DateTime lastRecheck, DateTime lastClick
    ) {
        super(hostId, threat, displayName, sanction, verdicts, threatUrlSamples);
        this.nextRecheckAfter = nextRecheckAfter;
        this.lastRecheck = lastRecheck;
        this.lastClick = lastClick;
    }

    @Description("Дата, когда угрозу можно будет перепроверить в следующий раз, если запросить проверку сейчас  (может отсутствовать)")
    public DateTime getNextRecheckAfter() {
        return nextRecheckAfter;
    }

    @Description("Дата, когда кнопка отлипла  (может отсутствовать)")
    public DateTime getLastRecheck() {
        return lastRecheck;
    }

    @Description("Дата, когда проверка была запрошена последний раз  (может отсутствовать)")
    public DateTime getLastClick() {
        return lastClick;
    }
}
