package ru.yandex.webmaster3.viewer.http.threats.data;

import com.fasterxml.jackson.annotation.JsonCreator;
import org.joda.time.DateTime;
import ru.yandex.autodoc.common.doc.annotation.Description;

import java.util.List;

/**
 * @author avhaliullin
 */
public class UrlSampleView {
    private final String url;
    private final DateTime lastChecked;
    private final List<String> infectionChain;

    @JsonCreator
    public UrlSampleView(String url, DateTime lastChecked, List<String> infectionChain) {
        this.url = url;
        this.lastChecked = lastChecked;
        this.infectionChain = infectionChain;
    }

    public String getUrl() {
        return url;
    }

    @Description("Дата последней проверки урла")
    public DateTime getLastChecked() {
        return lastChecked;
    }

    @Description("Цепочка заражения (может отсутствовать)")
    public List<String> getInfectionChain() {
        return infectionChain;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;

        UrlSampleView that = (UrlSampleView) o;

        if (!url.equals(that.url)) return false;
        if (lastChecked != null ? !lastChecked.equals(that.lastChecked) : that.lastChecked != null) return false;
        return infectionChain != null ? infectionChain.equals(that.infectionChain) : that.infectionChain == null;
    }

    @Override
    public int hashCode() {
        return url.hashCode();
    }
}
