package ru.yandex.webmaster3.viewer.http.turbo;

import lombok.Value;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.data.WebmasterHostId;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.autoparser.AutoparserToggleState;
import ru.yandex.webmaster3.core.user.UserVerifiedHost;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.service.autoparser.TurboAutoparserInfoService;
import ru.yandex.webmaster3.storage.user.service.UserHostsService;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsKey;
import ru.yandex.webmaster3.storage.user.settings.FrontendUserHostSettingsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

import java.util.List;
import java.util.Optional;

/**
 * @author: ishalaru
 * DATE: 03.09.2019
 */
@ReadAction
@Category("turbo")
@Description("Возвращает список хостов для пользователя, если у хоста выключен автопарсер")
@Component("/turbo/user/hosts")
public class GetHostsWithEnabledTurboAutoparser extends AbstractUserAction<GetHostsWithEnabledTurboAutoparser.Request, GetHostsWithEnabledTurboAutoparser.Response> {

    public static final String SPEED = "speed";
    private final UserHostsService userHostsService;
    private final TurboAutoparserInfoService turboAutoparserInfoService;
    private final FrontendUserHostSettingsYDao frontendUserHostSettingsYDao;

    public GetHostsWithEnabledTurboAutoparser(UserHostsService userHostsService,
                                              TurboAutoparserInfoService turboAutoparserInfoService,
                                              FrontendUserHostSettingsYDao frontendUserHostSettingsYDao) {
        this.userHostsService = userHostsService;
        this.turboAutoparserInfoService = turboAutoparserInfoService;
        this.frontendUserHostSettingsYDao = frontendUserHostSettingsYDao;
    }

    @Override
    public Response process(Request request) {
        List<UserVerifiedHost> verifiedHosts =
                userHostsService.getVerifiedHosts(request.getWebmasterUser());
        Optional<UserVerifiedHost> result = verifiedHosts
                .stream()
                .filter(e -> AutoparserToggleState.OFF == turboAutoparserInfoService
                        .getAutoparseCheckBoxState(WwwUtil.cutWWWAndM(e.getWebmasterHostId()))
                ).filter(e ->
                        !SPEED.equals(frontendUserHostSettingsYDao.getValue(
                                request.getUserId(), e.getWebmasterHostId(), FrontendUserHostSettingsKey.TURBO_AUTOPARSER_POPUP)))
                .findAny();
        if (result.isPresent()) {
            return new Response.NormalResponse(result.get().getWebmasterHostId());
        } else {
            return new Response.NormalResponse(null);
        }
    }

    public static class Request extends AbstractUserRequest {

    }

    public static abstract class Response implements ActionResponse {

        @Value
        public static class NormalResponse extends Response implements ActionResponse.NormalResponse {
            @Description("Хост у которых выключен автопарсер")
            private final WebmasterHostId hostId;
        }

    }
}
