package ru.yandex.webmaster3.viewer.http.turbo;

import ru.yandex.webmaster3.core.turbo.model.TurboSampleData;

import java.util.concurrent.ThreadLocalRandom;

/**
 * Created by ifilippov5 on 26.06.18.
 */
public class TurboSampleDataView {

    private static final String PREVIEW_URL_SUFFIX = "&from=webmaster&ncrnd=";

    private final String url;
    private final String title;
    private final String turboUrl;

    public TurboSampleDataView(String url, String title, String turboUrl) {
        this.url = url;
        this.title = title;
        this.turboUrl = turboUrl;
    }

    public String getUrl() {
        return url;
    }

    public String getTitle() {
        return title;
    }

    public String getTurboUrl() {
        return turboUrl;
    }

    public static TurboSampleDataView fromData(TurboSampleData sample) {
        return new TurboSampleDataView(
                sample.getOriginUrl(),
                sample.getTitle(),
                sample.getTurboUrl() + PREVIEW_URL_SUFFIX + ThreadLocalRandom.current().nextLong());
    }
}
