package ru.yandex.webmaster3.viewer.http.turbo.adv;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.viewer.http.AbstractUserAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserRequest;

/**
 * ishalaru
 * 18.09.2020
 **/
@WriteAction
@Category("turbo")
@Component("/turbo/adv/userExistsInRsi")
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class GetAdvRsiAccountExistensAction extends AbstractUserAction<GetAdvRsiAccountExistensAction.Request, GetAdvRsiAccountExistensAction.AbResponse> {
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public AbResponse process(Request request) {
        final boolean b = turboAutoAdvService.userIsExists(request.getUserId());
        return new AbResponse.Response(b);
    }

    @Data
    public static class Request extends AbstractUserRequest {
        @Setter(onMethod_ = {@Description("Домен по которому пришла заявка"), @RequestQueryProperty(required = true)})
        private String domain;
    }

    public static abstract class AbResponse implements ActionResponse {
        public static class Response extends AbResponse implements ActionResponse.NormalResponse {
            private final Boolean userAccountExistInRsi;

            public Response(Boolean userAccountExistInRsi) {
                this.userAccountExistInRsi = userAccountExistInRsi;
            }

            @Description("Существует ли пользователь в RSI")
            public Boolean getUserAccountExistInRsi() {
                return userAccountExistInRsi;
            }
        }

        public static class ErrorResponse extends AbResponse implements ActionResponse.ErrorResponse {

            @Override
            public Enum<?> getCode() {
                return Error.REQUEST_TO_THIS_USER_NOT_FOUND;
            }
        }
    }

    private enum Error {
        REQUEST_TO_THIS_USER_NOT_FOUND
    }
}
