package ru.yandex.webmaster3.viewer.http.turbo.adv;

import com.google.common.base.Strings;
import lombok.AllArgsConstructor;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.TurboHostSettings;
import ru.yandex.webmaster3.core.turbo.model.advertising.AdvertisingSettings;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.dao.adv.TurboAdvBlockPostponedYDao;
import ru.yandex.webmaster3.storage.turbo.service.adv.AutoAdvStatus;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAdvStatus;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.storage.turbo.service.settings.TurboSettingsService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 09.09.2020
 **/
@ReadAction
@Category("turbo")
@Component("/turbo/adv/turboAutoAdvStatus")
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class GetTurboAutoAdvStatusAction extends AbstractUserVerifiedHostAction<GetTurboAutoAdvStatusAction.Request, GetTurboAutoAdvStatusAction.Response> {
    private final TurboAutoAdvService turboAutoAdvService;
    private final TurboAdvBlockPostponedYDao turboAdvBlockPostponedYDao;
    private final TurboSettingsService turboSettingsService;

    @Override
    public Response process(Request request) {
        Pair<AutoAdvStatus, TurboAdvStatus> status = turboAutoAdvService.loadStatus(request.getHostId());
        String externalEmail = null;
        final TurboHostSettings settings = turboSettingsService.getSettings(request.getHostId());
        boolean haveManualBlocks = false;
        for (AdvertisingSettings item : settings.getAdvertisingSettingsList()) {
            if (!Strings.isNullOrEmpty(item.getValue())) {
                haveManualBlocks = true;
                break;
            }
        }
        if (status == null || status.getKey() == AutoAdvStatus.USER_SELECT_AUTO_ADV) {
            AutoAdvStatus autoAdvStatus = turboAutoAdvService.userIsExists(request.getUserId()) ? AutoAdvStatus.USER_WITH_RSI_ACCOUNT : AutoAdvStatus.USER_WITHOUT_RSI_ACCOUNT;
            if (status != null && status.getKey() == AutoAdvStatus.USER_SELECT_AUTO_ADV) {
                status = Pair.of(autoAdvStatus, TurboAdvStatus.AUTO);
            } else {
                status = Pair.of(autoAdvStatus, haveManualBlocks ? TurboAdvStatus.MANUAL : TurboAdvStatus.AUTO);
            }
        } else if (status.getValue() == TurboAdvStatus.AUTO && status.getKey() == AutoAdvStatus.WAIT_EXTERNAL_USER_VERIFICATION) {
            externalEmail = turboAdvBlockPostponedYDao.load(WwwUtil.cutWWWAndM(request.getHostId())).getData().getEmail();
        }

        return new Response(status.getKey(), status.getValue(), externalEmail, haveManualBlocks);
    }

    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    public static class Response implements ActionResponse.NormalResponse {
        private final AutoAdvStatus status;
        private final String externalEmail;
        private final TurboAdvStatus turboAdvStatus;
        private final boolean haveManualBlocks;

        public Response(AutoAdvStatus status, TurboAdvStatus turboAdvStatus, String externalLogin, boolean haveManualBlocks) {
            this.status = status;
            this.externalEmail = externalLogin;
            this.turboAdvStatus = turboAdvStatus;
            this.haveManualBlocks = haveManualBlocks;
        }

        public String getExternalEmail() {
            return externalEmail;
        }

        public AutoAdvStatus getStatus() {
            return status;
        }

        @Description("Статус рекламы")
        public TurboAdvStatus getTurboAdvStatus() {
            return turboAdvStatus;
        }

        public boolean isHaveManualBlocks() {
            return haveManualBlocks;
        }
    }
}
