package ru.yandex.webmaster3.viewer.http.turbo.adv;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.adv.AdvIntegrationException;
import ru.yandex.webmaster3.storage.turbo.service.adv.AutoAdvStatus;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 02.09.2020
 **/
@WriteAction
@Category("turbo")
@Description("Заводит авторекламу для турбо")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
@Component("/turbo/adv/initAutoAdv")
public class InitTurboAutoAdvAction extends AbstractUserVerifiedHostAction<InitTurboAutoAdvAction.Request, InitTurboAutoAdvAction.AbResponse> {
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public AbResponse process(Request request) {

        Long user = request.getUserId();
        if (!turboAutoAdvService.userIsExists(user)) {
            return new AbResponse.ErrorResponse();
        } else {
            try {
                final AutoAdvStatus autoAdvStatus = turboAutoAdvService.initTurboAutoAdvBlocks(String.valueOf(user), request.getHostId());
                return new AbResponse.Response(autoAdvStatus);
            } catch (AdvIntegrationException autoAdvStatus) {
                return new AbResponse.RsiErrorResponse();
            }
        }
    }

    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    public static abstract class AbResponse implements ActionResponse {
        public static class Response extends AbResponse implements ActionResponse.NormalResponse {
            private final AutoAdvStatus autoAdvStatus;

            public Response(AutoAdvStatus autoAdvStatus) {
                this.autoAdvStatus = autoAdvStatus;
            }

            @Description("Статус проделанной работы")
            public AutoAdvStatus getAutoAdvStatus() {
                return autoAdvStatus;
            }
        }

        public static class ErrorResponse extends AbResponse implements ActionResponse.ErrorResponse {

            @Override
            public Enum<?> getCode() {
                return Error.RSI_ACCOUNT_NOT_EXISTS;
            }
        }

        public static class RsiErrorResponse extends AbResponse implements ActionResponse.ErrorResponse {

            @Override
            public Enum<?> getCode() {
                return AdvIntegrationException.ErrorType.RSI_INTERNAL_ERROR;
            }
        }
    }

    public enum Error {
        RSI_ACCOUNT_NOT_EXISTS
    }
}
