package ru.yandex.webmaster3.viewer.http.turbo.adv;

import lombok.AllArgsConstructor;
import lombok.Data;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 18.09.2020
 **/
@WriteAction
@Category("turbo")
@Component("/turbo/adv/resetTurboAdvStatusAction")
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class ResetTurboAdvStatusAction extends AbstractUserVerifiedHostAction<ResetTurboAdvStatusAction.Request, ResetTurboAdvStatusAction.Response> {
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public Response process(Request request) {

        turboAutoAdvService.resetStatus(WwwUtil.cutWWWAndM(request.getHostId()));
        return new Response();
    }

    @Data
    public static class Request extends AbstractUserVerifiedHostRequest {
    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
