package ru.yandex.webmaster3.viewer.http.turbo.adv;

import java.util.UUID;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.adv.AutoAdvUserVerifyTaskData;
import ru.yandex.webmaster3.core.util.EmailValidator;
import ru.yandex.webmaster3.core.worker.client.WorkerClient;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 09.09.2020
 **/
@WriteAction
@Category("turbo")
@Component("/turbo/adv/sendTurboAutoAdvQueryAction")
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class SendTurboAutoAdvQueryAction extends AbstractUserVerifiedHostAction<SendTurboAutoAdvQueryAction.Request, SendTurboAutoAdvQueryAction.AbResponse> {
    private final WorkerClient workerClient;
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public AbResponse process(Request request) {
        if (!EmailValidator.isValid(request.getEmail())) {
            return new AbResponse.InvalidEmailFormat();
        }
        final String key = UUID.randomUUID().toString();
        turboAutoAdvService.waitUserEmailVerification(request.getHostId(), request.getEmail(), key);
        workerClient.enqueueTask(new AutoAdvUserVerifyTaskData(request.getHostId(), request.getEmail(), request.getUserId(), key));
        return new AbResponse.Response();
    }


    @Data
    public static class Request extends AbstractUserVerifiedHostRequest {
        @Setter(onMethod_ = {@Description("Почта внешнего пользователя"), @RequestQueryProperty(required = true)})
        private String email;
    }

    public static abstract class AbResponse implements ActionResponse {
        public static class Response extends AbResponse implements ActionResponse.NormalResponse {
        }

        public static class InvalidEmailFormat extends AbResponse implements ActionResponse.ErrorResponse {

            @Override
            public Enum<?> getCode() {
                return Error.INVALID_EMAIL;
            }
        }
    }

    public enum Error {
        INVALID_EMAIL
    }
}
