package ru.yandex.webmaster3.viewer.http.turbo.adv;

import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.Setter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.service.adv.AutoAdvStatus;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAdvStatus;
import ru.yandex.webmaster3.storage.turbo.service.adv.TurboAutoAdvService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 18.09.2020
 **/
@WriteAction
@Category("turbo")
@Component("/turbo/adv/updateTurboAdvStatus")
@AllArgsConstructor(onConstructor_ = {@Autowired})
public class SetTurboAdvStatusAction extends AbstractUserVerifiedHostAction<SetTurboAdvStatusAction.Request, SetTurboAdvStatusAction.Response> {
    private final TurboAutoAdvService turboAutoAdvService;

    @Override
    public Response process(Request request) {
        TurboAdvStatus turboAdvStatus = TurboAdvStatus.AUTO;
        if (request.getTurboAdvStatus() != null) {
            turboAdvStatus = request.getTurboAdvStatus();
        }
        turboAutoAdvService.setStatus(WwwUtil.cutWWWAndM(request.getHostId()), request.getAdvStatus(), turboAdvStatus);
        return new Response();
    }

    @Data
    public static class Request extends AbstractUserVerifiedHostRequest {
        @Setter(onMethod_ = {@Description("Статус авто рекламы"), @RequestQueryProperty(required = true)})
        private AutoAdvStatus advStatus;
        @Setter(onMethod_ = {@Description("Статус рекламы"), @RequestQueryProperty(required = false)})
        private TurboAdvStatus turboAdvStatus;

    }

    public static class Response implements ActionResponse.NormalResponse {
    }
}
