package ru.yandex.webmaster3.viewer.http.turbo.autoparser;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.turbo.model.autoparser.AutoparserToggleState;

/**
 * Created by ifilippov5 on 21.06.18.
 */
public enum AutoparserToggleStateView {
    @Description("Отсутствует")
    ABSENT,
    @Description("Включен")
    ON,
    @Description("Выключен")
    OFF,
    ;

    public static AutoparserToggleStateView fromInternalState(AutoparserToggleState state) {
        switch (state) {
            case ON:
                return ON;
            case OFF:
                return OFF;
            case INHERITS:
                return OFF; // не должно быть такого
            case ABSENT:
                return ABSENT;
        }
        throw new IllegalStateException();
    }
}
