package ru.yandex.webmaster3.viewer.http.turbo.autoparser;

import lombok.AllArgsConstructor;
import lombok.Getter;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Component;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.service.TurboSpeedLandingService;
import ru.yandex.webmaster3.storage.turbo.service.TurboSpeedLandingService.TurboSpeedLandingInfo;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.host.verification.UsersVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.turbo.autoparser.GetAutoparserLandingInfo2Action.Request;
import ru.yandex.webmaster3.viewer.http.turbo.autoparser.GetAutoparserLandingInfo2Action.Response;

/**
 * Created by Oleg Bazdyrev on 2019-07-17.
 */
@Description("Получение инфы для нового лендинга по автопарсеру с данными по скорости (с учетом конкурентов)")
@Category("turbo")
@ReadAction
@Component("/turbo/autoparser/landing2")
@RequiredArgsConstructor
public class GetAutoparserLandingInfo2Action extends AbstractUserVerifiedHostAction<Request, Response> {

    private final TurboSpeedLandingService turboSpeedLandingService;

    @Override
    public Response process(Request request) {
        return new Response(turboSpeedLandingService.findSpeedLandingInfo(WwwUtil.cutWWWAndM(request.getHostId())));
    }

    public static final class Request extends UsersVerifiedHostRequest {

    }

    @AllArgsConstructor
    @Getter
    public static final class Response implements ActionResponse.NormalResponse {
        @Description("Инфа про скорость и скриншоты")
        private final TurboSpeedLandingInfo info;
    }
}
