package ru.yandex.webmaster3.viewer.http.turbo.autoparser;

import org.springframework.beans.factory.annotation.Required;
import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.WebmasterException;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.http.WebmasterErrorResponse;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.autoparser.AutoparserToggleState;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.turbo.service.autoparser.TurboAutoparserInfoService;
import ru.yandex.webmaster3.storage.turbo.service.autoparser.TurboAutoparserInfoUtil;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;

/**
 * Created by ifilippov5 on 19.06.18.
 */
@ReadAction
@Category("turbo")
@Description("Информация про галку автопарсера")
public class GetAutoparserToggleStateAction extends AbstractUserVerifiedHostAction<GetAutoparserToggleStateRequest, GetAutoparserToggleStateResponse> {

    private TurboAutoparserInfoService turboAutoparserInfoService;

    @Override
    public GetAutoparserToggleStateResponse process(GetAutoparserToggleStateRequest request) {
        try {
            String host = TurboAutoparserInfoUtil.canonizeHost(request.getHostId());
            AutoparserToggleState internalState = turboAutoparserInfoService.getAutoparseCheckBoxState(host);
            AutoparserToggleStateView state = AutoparserToggleStateView.fromInternalState(internalState);
            return new GetAutoparserToggleStateResponse.NormalResponse(state);
        } catch (WebmasterYdbException e) {
            throw new WebmasterException("Error reading autoparse checkbox state",
                    new WebmasterErrorResponse.YDBErrorResponse(getClass(), e), e);
        }
    }

    @Required
    public void setTurboAutoparserInfoService(TurboAutoparserInfoService turboAutoparserInfoService) {
        this.turboAutoparserInfoService = turboAutoparserInfoService;
    }
}
