package ru.yandex.webmaster3.viewer.http.turbo.autoparser;

import java.util.Collections;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.autoparser.TurboAutoparsedHostInfo;
import ru.yandex.webmaster3.core.turbo.model.feed.TurboFeedType;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.dao.autoparser.TurboAutoparsedYDao;
import ru.yandex.webmaster3.storage.turbo.dao.statistics.TurboDomainStatisticsYDao;
import ru.yandex.webmaster3.storage.turbo.service.autoparser.TurboAutoparserInfoService;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.turbo.TurboSampleDataView;

/**
 * Created by ifilippov5 on 19.06.18.
 */
@ReadAction
@Category("turbo")
@Description("Получить примеры страниц от автопарсера")
@Component("/turbo/autoparser/samples")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ListTurboAutoparsedSamplesAction extends AbstractUserVerifiedHostAction<ListTurboAutoparsedSamplesRequest, ListTurboAutoparsedSamplesResponse> {

    private final TurboAutoparsedYDao turboAutoparsedYDao;
    private final TurboAutoparserInfoService turboAutoparserInfoService;
    private final TurboDomainStatisticsYDao turboDomainStatisticsYDao;

    @Override
    public ListTurboAutoparsedSamplesResponse process(ListTurboAutoparsedSamplesRequest request) {
        String domain = WwwUtil.cutWWWAndM(request.getHostId());
        TurboAutoparsedHostInfo info = turboAutoparsedYDao.get(domain);
        boolean hasPages = turboAutoparserInfoService.isHostInfoActual(info);
        long pagesCount = 0;
        if (!hasPages) {
            return new ListTurboAutoparsedSamplesResponse.NormalResponse(Collections.emptyList(), pagesCount);
        }
        pagesCount = turboDomainStatisticsYDao.getValue(domain, TurboFeedType.AUTO);
        if (pagesCount == 0L) {
            pagesCount = turboDomainStatisticsYDao.getValue(domain, TurboFeedType.AUTO_DISABLED);
        }
        return new ListTurboAutoparsedSamplesResponse.NormalResponse(
                info.getSamples().stream().map(TurboSampleDataView::fromData).collect(Collectors.toList())
                , pagesCount);
    }
}
