package ru.yandex.webmaster3.viewer.http.turbo.autoparser;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.viewer.http.turbo.TurboSampleDataView;

import java.util.List;

/**
 * Created by ifilippov5 on 20.06.18.
 */
public abstract class ListTurboAutoparsedSamplesResponse implements ActionResponse {

    public static class NormalResponse extends ListTurboAutoparsedSamplesResponse implements ActionResponse.NormalResponse {

        private final List<TurboSampleDataView> samples;
        private final long pagesCount;

        public NormalResponse(List<TurboSampleDataView> samples, long pagesCount) {
            this.samples = samples;
            this.pagesCount = pagesCount;
        }

        @Description("Примеры страниц от автопарсера. Максимум 10")
        public List<TurboSampleDataView> getSamples() {
            return samples;
        }

        @Description("Общее кол-во распаршенных страниц для домена и поддоменов")
        public long getPagesCount() {
            return pagesCount;
        }
    }
}
