package ru.yandex.webmaster3.viewer.http.turbo.autorelated;

import java.util.List;
import java.util.stream.Collectors;

import lombok.RequiredArgsConstructor;
import org.springframework.beans.factory.annotation.Autowired;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.model.TurboSampleData;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.util.ydb.exception.WebmasterYdbException;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsStateCHDao;
import ru.yandex.webmaster3.storage.turbo.dao.TurboDomainsStateHelper;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;
import ru.yandex.webmaster3.viewer.http.turbo.TurboSampleDataView;
import ru.yandex.webmaster3.viewer.http.turbo.autorelated.ListTurboAutoRelatedSamplesAction.Request;
import ru.yandex.webmaster3.viewer.http.turbo.autorelated.ListTurboAutoRelatedSamplesAction.Response;

/**
 * Created by Oleg Bazdyrev on 02/08/2018.
 */
@ReadAction
@Category("turbo")
@Description("Получить примеры страниц с бесконечной лентой")
@RequiredArgsConstructor(onConstructor_ = @Autowired)
public class ListTurboAutoRelatedSamplesAction extends AbstractUserVerifiedHostAction<Request, Response> {

    private final TurboDomainsStateCHDao turboDomainsStateCHDao;

    @Override
    public Response process(Request request) {
        try {
            List<TurboSampleData> samples = turboDomainsStateCHDao.getDomainState(WwwUtil.cutWWWAndM(request.getHostId()), TurboDomainsStateHelper.getAutorelatedFields()).getAutorelatedSamples();
            if (samples == null) {
                return new Response(null);
            }
            return new Response(samples.stream().map(TurboSampleDataView::fromData).collect(Collectors.toList()));
        } catch (WebmasterYdbException e) {
            throw e.asUnchecked("Cassandra error", getClass());
        }
    }

    public static final class Request extends AbstractUserVerifiedHostRequest {

    }

    public static final class Response implements ActionResponse.NormalResponse {

        private final List<TurboSampleDataView> samples;

        public Response(List<TurboSampleDataView> samples) {
            this.samples = samples;
        }

        @Description("Примеры с бесконечной лентой")
        public List<TurboSampleDataView> getSamples() {
            return samples;
        }
    }
}
