package ru.yandex.webmaster3.viewer.http.turbo.comment;

import lombok.Data;
import lombok.RequiredArgsConstructor;
import lombok.Setter;
import lombok.Value;
import org.joda.time.LocalDate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.RequestQueryProperty;
import ru.yandex.webmaster3.core.http.WriteAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.core.turbo.TurboIntegrationService;
import ru.yandex.webmaster3.core.util.WwwUtil;
import ru.yandex.webmaster3.storage.turbo.dao.TurboCmntStatisticsYDao;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostAction;
import ru.yandex.webmaster3.viewer.http.AbstractUserVerifiedHostRequest;

/**
 * ishalaru
 * 01.06.2020
 **/
@WriteAction
@Description("Получение общего статуса подключения Турбо для e-commerce")
@Component("/turbo/cmnt/status/update")
@Category("turbo")
@RequiredArgsConstructor(onConstructor_ = {@Autowired})
public class TurboCmntStatusUpdateAction extends AbstractUserVerifiedHostAction<TurboCmntStatusUpdateAction.Request, TurboCmntStatusUpdateAction.Response> {
    private final TurboCmntStatisticsYDao turboCmntStatisticsYDao;
    private final TurboIntegrationService turboIntegrationService;

    @Override
    public Response process(Request request) {
        if (turboIntegrationService.updateTurboCmntStatus(request.getUrl(), request.isEnable())) {
            turboCmntStatisticsYDao.update(WwwUtil.cutWWWAndM(request.getHostId()), request.url, request.date, request.enable);
            return new Response.NResponse();
        } else {
            return new Response.EResponse(Response.ErrorCode.TURBO_IS_UNAVAILABLE);
        }
    }

    @Data
    public static final class Request extends AbstractUserVerifiedHostRequest {
        @Setter(onMethod_ = {@Description("Дата появления страницы"), @RequestQueryProperty(required = true)})
        LocalDate date;
        @Setter(onMethod_ = {@Description("Url"), @RequestQueryProperty(required = true)})
        String url;
        @Setter(onMethod_ = {@Description("enable"), @RequestQueryProperty(required = true)})
        boolean enable;
    }

    public static abstract class Response implements ActionResponse {
        public enum ErrorCode {
            TURBO_IS_UNAVAILABLE,
            YDB_IS_UNAVAILABLE
        }

        @Value
        public static final class NResponse extends Response implements ActionResponse.NormalResponse {
        }


        public static final class EResponse extends Response implements ActionResponse.ErrorResponse {
            ErrorCode errorCode;

            public EResponse(ErrorCode errorCode) {
                this.errorCode = errorCode;
            }

            @Override
            public Enum<?> getCode() {
                return errorCode;
            }
        }

    }
}
