package ru.yandex.webmaster3.viewer.http.turbo.commerce;

import lombok.Value;
import org.springframework.stereotype.Component;

import ru.yandex.autodoc.common.doc.annotation.Description;
import ru.yandex.webmaster3.core.http.ActionResponse;
import ru.yandex.webmaster3.core.http.ReadAction;
import ru.yandex.webmaster3.core.metrics.Category;
import ru.yandex.webmaster3.viewer.http.BaseWebmaster3Action;
import ru.yandex.webmaster3.viewer.http.request.AbstractFrontendRequest;
import ru.yandex.webmaster3.viewer.http.turbo.commerce.GenerateTurboBitrixTokenAction.Request;
import ru.yandex.webmaster3.viewer.http.turbo.commerce.GenerateTurboBitrixTokenAction.Response;

/**
 * Created by Oleg Bazdyrev on 11/03/2020.
 */
@ReadAction
@Category("turbo")
@Component("/turbo/ecommerce/genBitrixToken")
public class GenerateTurboBitrixTokenAction extends BaseWebmaster3Action<Request, Response> {

    private static final int DEFAULT_SALT = 7;
    private static final int EIGHT = 8;
    private static final int HEX = 16;
    private static final int DOUBLE_HEX = 32;
    private static final int FOUR_HEX = 64;

    @Override
    public Response process(Request request) {
        return new Response(salt(System.currentTimeMillis()));
    }

    // @see https://github.yandex-team.ru/market-java/mbi/blob/master/mbi-common/src/java/ru/yandex/market/mbi/util/salt/impl/DateSaltingService.java#L30
    private static String salt(long millis) {
        long t = millis;
        t = flipBits(t, FOUR_HEX);
        t = (t & (-1L << DOUBLE_HEX)) | flipBits(t & (-1L >>> DOUBLE_HEX), DOUBLE_HEX);
        return Long.toHexString(t).toUpperCase();
    }

    private static long flipBits(long t, int length) {
        int bitShift = (DEFAULT_SALT % (length - 1)) + 1;
        int bitShiftAdd = length - bitShift;
        return (t >>> bitShift) | ((t & (-1L >>> (FOUR_HEX - length) + bitShiftAdd)) << bitShiftAdd);
    }

    private static long flipBackBits(long t, int length) {
        int bitShift = (DEFAULT_SALT % (length - 1)) + 1;
        int bitShiftAdd = length - bitShift;
        return ((t << bitShift) | ((t & (-1L << bitShiftAdd)) >>> bitShiftAdd)) & (-1L >>> (FOUR_HEX - length));
    }

    public static long desalt(String saltedDate) {
        long t = parseLong(saltedDate);
        t = (t & (-1L << DOUBLE_HEX)) | flipBackBits(t & (-1L >>> DOUBLE_HEX), DOUBLE_HEX);
        t = flipBackBits(t, FOUR_HEX);
        return t;
    }

    private static long parseLong(String hex) {
        if (hex.length() > HEX) {
            throw new NumberFormatException("Hex string is too long");
        }
        long t = Long.parseLong(hex.substring(Math.max(hex.length() - EIGHT, 0), hex.length()), HEX);
        if (hex.length() > EIGHT) {
            t |= (Long.parseLong(hex.substring(0, Math.min(hex.length() - EIGHT, EIGHT)), HEX) << DOUBLE_HEX);
        }
        return t;
    }

    public static final class Request extends AbstractFrontendRequest {

    }

    @Value
    public static final class Response implements ActionResponse.NormalResponse {
        @Description("Сгенерированный токен")
        String token;
    }
}
